var Emotions = new Object;
Emotions.dot           = "DotEmotion.mng";          
Emotions.question    = "QuestionEmotion.mng";
Emotions.sweat       = "SweatDropEmotion.mng";
Emotions.annoyed    = "AnnoyedEmotion.mng";
Emotions.suprised    = "SuprisedEmotion.mng";
Emotions.love          = "LoveEmotion.mng";
Emotions.heartbreak = "HeartBreakEmotion.mng";
Emotions.angry        = "AngryEmotion.mng";

EvaluateSystemScript ("convert.js");
var gEmotions = new Array();
var EmotionCount = 0;

function RemoveArrayItem (from,item) {
  from.splice(item,1);
  return from;
}

function DoesPersonExist (name) {
  var list = GetPersonList();
  for (var i = 0; i < list.length; ++i)
    if (list[i] == name) {
      return true;
    }
  return false;
}

function Emotion (person, animation) {
  if (person == undefined) Debug ("Error at: " + animation);
  switch (animation) {      // Have to add frames manualy, thanks to .mng files not functioning properly.
    case Emotions.dot: {                    // Dot emotion
      this.max_frames = 5; break;           
    }
    case Emotions.question: {             // Question mark emotion
      this.max_frames = 6; break;
    }
    case Emotions.sweat: {                // Sweatdrop
      this.max_frames = 5; break;
    }
    case Emotions.heartbreak: {          // Heart break
      this.max_frames = 5; break;
    }
    case Emotions.annoyed: {             // Annoyed
      this.max_frames = 6; break;
    }
    case Emotions.suprised: {              // Suprised
      this.max_frames = 6; break;
    }
    case Emotions.love: {                    // Love
      this.max_frames = 6; break;
    }
    case Emotions.angry: {                  // Anger
      this.max_frames = 6; break;
    }    
    case Default: {
      Debug ("Error at: " + person); break;
    }
  }
  
  this.person = person;
  this.animation = LoadAnimation (animation);
  this.cur_frame = 0;
  this.update_time = GetTime() + this.animation.getDelay();
}

function SetPersonEmotion(person, animation) {
  if (!IsPersonInEmotion(person)) {
    gEmotions.push (new Emotion(person, animation));
    EmotionCount ++;
  }
} 

function ClearEmotions() {
  gEmotions = new Array();
}

function IsPersonInEmotion(person) {
  return (GetPersonEmotionIndex(person) > -1);
}

function GetPersonEmotionIndex(person) {
  for (var i = 0; i < gEmotions.length; ++i)
    if (gEmotions[i].person == person)
      return i;
  return -1;
}

function UpdateEmotions() {
  for (var i = 0; i < gEmotions.length; ++i) {
    if (gEmotions[i].cur_frame < gEmotions[i].max_frames) {
      var person = gEmotions[i].person;
      var spriteset = GetPersonSpriteset(person);
      var x = ScreenX(GetPersonX(person));
      var y = ScreenY(GetPersonY(person) - spriteset.images[i].height - 5);          
      gEmotions[i].animation.drawFrame(x, y);  // draw emotion      
      if (gEmotions[i].update_time <= GetTime()) { // Check to see if we need to update.
        gEmotions[i].cur_frame ++; // If so, next frame.
        gEmotions[i].animation.readNextFrame(); // Read next frame.
        gEmotions[i].update_time = GetTime() + gEmotions[i].animation.getDelay(); // Update
      }
    } 
    else 
    {
      gEmotions = RemoveArrayItem (gEmotions,i);
      EmotionCount --;
    }
  }
  if (EmotionCount == 0) ClearEmotions();
}